package w83a.w83aManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aBeans.W83aDelegadosBean;
import w83a.w83aBeans.W83aDelegadosEqualsBean;
import w83a.w83aBeans.W83aNuevaIncidenciasBean;
import w83a.w83aDAO.W83aFactoriaDAO;
import w83a.w83aDAO.w83aConstantesBD.W83aIncidenciasTipoSustitucionBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;


// TODO: Auto-generated Javadoc
/**
 * The Class W83aIncidencias.
 */
public class W83aIncidencias implements W83aIIncidencias {
	
		public W83aNuevaIncidenciasBean detalleIncidencia(W83aNuevaIncidenciasBean incidencia)throws Exception{
//		INSERTA LNEA DE CONSULTA DE LA INCIDENCIA EN LA TABLA DE HISTORIAL
		//W83aFactoriaDAO.getIncidenciaDAO().anyadirIncidenciaAuditoria(incidencia,W83aClsConstantes.CONSTANTE_HISTORIAL_MODO_LECTURA);
//		FIN INSERTA LNEA DE CONSULTA DE LA INCIDENCIA EN LA TABLA DE HISTORIAL
			W83aNuevaIncidenciasBean nuevaIncidencias =new W83aNuevaIncidenciasBean();
		nuevaIncidencias = (W83aNuevaIncidenciasBean)W83aFactoriaDAO.getIncidenciaDAO().detalleIncidencias(incidencia).get(0);
		
//descomentado por Ana. Estaba comentado por Leire
		if(W83aClsConstantes.CONSTANTE_SUBSANACION.equals(nuevaIncidencias.getTipologiaIncidencia())||
				W83aClsConstantes.CONSTANTE_ACTA_PARCIAL.equals(nuevaIncidencias.getTipologiaIncidencia())){
			nuevaIncidencias.setIdioma(incidencia.getIdioma());
			nuevaIncidencias.setListaCambiosSubnacion(W83aFactoriaDAO.getIncidenciaDAO().obtenerCambiosSubsanacionIncidencias(nuevaIncidencias));
		}
//fin descomentado		
		List delegadosSustitucion = W83aFactoriaDAO.getIncidenciaDAO().obtenerDelegadosSustitucion(nuevaIncidencias);
		
		List delegadosTabla = new ArrayList();
		
		for(int i=0,size = delegadosSustitucion.size();i<size;i++){
			HashMap mapaDelegado = (HashMap)delegadosSustitucion.get(i);
			W83aDelegadosBean beanViejo = new W83aDelegadosBean();//NOPMD
			beanViejo.setActaAnyo(nuevaIncidencias.getActaAnyo());
			beanViejo.setActaNum(nuevaIncidencias.getActaNumero());
			beanViejo.setActaTerritorio(nuevaIncidencias.getActaTerritorio());
			beanViejo.setActaVersion(nuevaIncidencias.getActaVersion());
			beanViejo.setUsuarioBean(incidencia.getUsuarioBean());
	
			beanViejo.setDniDelegado((String)mapaDelegado.get(W83aIncidenciasTipoSustitucionBD.DNI_SUSTITUTO_067));				
			beanViejo.setIdioma(incidencia.getIdioma());
		
			W83aDelegadosEqualsBean delegadoEqual = new W83aDelegadosEqualsBean();//NOPMD
			delegadoEqual.setDniDelegado(beanViejo.getDniDelegado());
			
			int posDiferenica = -1;
			
			if(StringUtils.isNotEmpty(beanViejo.getDniDelegado())){
				posDiferenica = delegadosTabla.indexOf(delegadoEqual);
			}
			if(posDiferenica==-1){					
				List listaDelegados = new ArrayList();//NOPMD
					
				if(StringUtils.isNotEmpty(beanViejo.getDniDelegado())){
					listaDelegados = W83aFactoriaDAO.getIncidenciaDAO().buscarDetalleDelegadoIncidencias(beanViejo,false);
				}
				
				if(0<listaDelegados.size()){

						delegadosTabla.addAll(listaDelegados);
					}
					beanViejo.setDniDelegado((String)mapaDelegado.get(W83aIncidenciasTipoSustitucionBD.DNI_SUTITUIDO_067));
					listaDelegados = W83aFactoriaDAO.getIncidenciaDAO().buscarDetalleDelegadoIncidencias(beanViejo,false);
					
					if(0<listaDelegados.size()){

						delegadosTabla.addAll(listaDelegados);
					}
				}
		}
		
		W83aDelegadosBean beanViejo = new W83aDelegadosBean();//NOPMD
		beanViejo.setActaAnyo(nuevaIncidencias.getActaAnyo());
		beanViejo.setActaNum(nuevaIncidencias.getActaNumero());
		beanViejo.setActaTerritorio(nuevaIncidencias.getActaTerritorio());
		beanViejo.setActaVersion(nuevaIncidencias.getActaVersion());
		beanViejo.setIdioma(incidencia.getIdioma());
		beanViejo.setUsuarioBean(incidencia.getUsuarioBean());
		
		nuevaIncidencias.setListaDelegados(delegadosTabla);
		
		nuevaIncidencias.setListaDocs(W83aFactoriaDAO.getIncidenciaDAO().obtenerDocumentosIncidencia(incidencia));
		
		//nuevaIncidencias.setListaAuditoriaIncidencias(W83aFactoriaDAO.getIncidenciaDAO().obtenerRegistrosAuditoria(incidencia));
		
		//nuevaIncidencias.setListaHistorialIncidencias(W83aFactoriaDAO.getIncidenciaDAO().obtenerRegistrosTramitacion(incidencia));
		
		
		return nuevaIncidencias;
	}
		/**
		 * Existe acta tabla actas.
		 *
		 * @param incidencia the incidencia
		 * @return true, if successful
		 * @throws Exception the exception
		 */
		public List obtenerDelegadosSustitucion(W83aNuevaIncidenciasBean incidencia) throws Exception{
			StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("SELECT ");
			strSql.append(W83aIncidenciasTipoSustitucionBD.DNI_SUSTITUTO_067);
			strSql.append(", ");
			strSql.append(W83aIncidenciasTipoSustitucionBD.DNI_SUTITUIDO_067);
			
			strSql.append(" FROM ").append(W83aIncidenciasTipoSustitucionBD.incidenciasTipoSustitucionSinonimo);
			
			strSql.append(" WHERE ").append(W83aIncidenciasTipoSustitucionBD.ANO_INCID_067).append(" = ? ");
			params.add(new Integer(incidencia.getIncidenciaAnyo()));		
			strSql.append(" AND ").append(W83aIncidenciasTipoSustitucionBD.N_INCID_067).append(" = ? ");
			params.add(new Integer(incidencia.getIncidenciaNumero()));		
			strSql.append(" AND ").append(W83aIncidenciasTipoSustitucionBD.C_TERRIT_067).append(" = ? ");
			params.add(incidencia.getIncidenciaTerritorio());		
			
			
			return W83aDataBase.executeQuery(strSql.toString(),params,incidencia.getUsuarioBean());		
		}
		public w83a.w83aBeans.W83aDocBean descargarDocumentoIncidencias(String idDocumento)throws Exception{
			return W83aFactoriaDAO.getIncidenciaDAO().descargarDocumento(idDocumento);
		}
	
}